﻿local _,L = ...

if GetLocale()=="ruRU" then

-- Localization Rematch 4.7.3 last update  13.07.2017 10:32 GMT

-- Main.lua
	L["Rematch"] = nil
	L["Toggle Window"] = "Переключить окно"
	L["Auto Load"] = "Автозагрузка"
	L["Team Notes"] = "Заметки команды"
	L["Pets Tab"] = "Вкладка питомцев"
	L["Teams Tab"] = "Вкладка команд"
	L["Queue Tab"] = "Вкладка Очереди"
	L["Toggle Rematch"] = "Переключить Rematch"
	L["Load this team?"] = "Загрузить эту команду?"
	L["They do not appear to be online."] = "Они похоже не в сети."
	L["has also been added to your leveling queue!"] = "также добавлен в вашу очередь прокачивания!"
	L["The team named '%s' can't be found."] = "Команда с именем '%s' не найдена"
	L["Rematch Debug Info"] = "Информация об отладке Rematch"

-- Utils.lua
	L["Leveling Pet"] = "Питомец для прокачивания"

-- Widgets\PetListButtons.lua
	L["A New Pet!"] = "Новый питомец!"
	L["Empty Battle Pet Slot"] = "Пустой слот для боевого питомца"
	L["This pet can't level."] = "Этот питомец не может прокачиватся."
	L["Only pets that can battle and are under 25 can go in the leveling queue."] = "Только питомцы, которые могут сражаться и не достигли 25 уровня, могут находится в очереди прокачивания."

-- Widgets\Toolbar.lua
	L["Total Pets"] = "Всего Питомцев"
	L["Unique Pets"] = "Уникальных"
	L["Save As..."] = "Сохранить как..."
	L["Save the currently loaded pets to a new team."] = "Сохранить загруженных на этот момент питомцев в новой команде."
	L["Save the currently loaded pets to the loaded team."] = "Сохранить загруженных на этот момент питомцев в загруженную команду."
	L["Dismiss Pet"] = "Отпустить питомца"
	L["Summon Pet"] = "Призвать питомца"
	L["Summons a random pet from your favorites."] = "Призывает случайного питомца из ваших избранных."
	L["Random Favorite"] = "Случайный избранный питомец"
	L["Random From All"] = "Случайный питомец"
	L["All pets are at full health."] = "Все питомцы с полным здоровьем."
	L["This treat's buff is already active."] = "Бафф от этого лакомства уже активен."
	L["%s\n\nPets At Max Level: %s%d\124r\nPets Not Collected: %s%d\124r\n\n%s Click to display more about your collection."] = "%s\n\nМакстимального уровня: %s%d\124r\nПитомцев не собрано: %s%d\124r\n\n%s Нажмите, чтобы узнать больше о вашей коллекции."

-- Widgets\MinimapButton.lua
	L["Load Favorite Team"] = "Загрузить избранную команду"
	L["Favorite Teams"] = "Избранные команды"
	
-- Process\PetInfo.lua
    L["Random %s"] = "Случайный %s"
	L["Ignored Pet"] = "Игнорируемый питомец"
	L["Unknown"] = "Неизвестный"

-- Process\PetLoading.lua
	L["You can't load a team during combat."] = "Вы не можете загрузить команду во время боя."
	L["You can't load a team during a pet battle."] = "Вы не можете загрузить команду во время битвы питомцев."
	L["You can't load a team in a matched pet battle."] = "Вы не можете загрузить команду во время ожидания очереди битвы питомцев."
	L["Loading..."] = "Загрузка..."
	L["Pets are missing from this team!"] = "В этой команде не хватает питомцев!"
	L["Substitutes were found. Please review the loaded team and click Save if you'd like to keep the chosen pets."] = "Были найдены заменители. Проверьте загруженную команду и нажмите «Сохранить», если вы хотите сохранить выбранных питомцев."
	L["Don't Warn About Missing Pets"] = "Не предупреждать о не хватающих питомцах"

-- Process\Filters.lua
	L["Favorites"] = "Избранные"
	L["Types"] = "Типы"
	L["Strong Vs"] = "Сильные против"
	L["Tough Vs"] = "Устойчивые против"
	L["Breed"] = "Порода"
	L["Similar"] = "Похожие"
	L["Script"] = "Скрипт"
	L["Level"] = "Уровень"
	L["Leveling"] = "Прокачка"
	L["Tradable"] = "Можно продать"
	L["Battle"] = "Боевой"
	L["Quantity"] = "Количество"
	L["Team"] = "Команда"
	L["Hidden"] = "Скрытые"
	L["Zone"] = "Зона"
	L["Notes"] = "Заметки"
	L["Search"] = "Поиск"
	L["Sort"] = "Упорядочить"
	L["Stats Search"] = "Поиск характеристик"
	L["Moveset"] = "Набор атак"

-- Process\QueueProcess.lua
	L["Now leveling:"] = "Сейчас прокачивается:"
	L["Rematch's leveling queue is empty"] = "Очередь прокачивания Rematch пуста"
	L["All done leveling pets!"] = "Все питомцы прокачаны!"

-- Process\Sanctuary.lua

-- Process\TeamStrings.lua
	L["%s (NPC#%d)"] = nil
	L["%s (%s NPC#%d)"] = nil
	L["%d: %s"] = nil
	L["%d: %s (%d,%d,%d)"] = nil
	L["Preferred leveling pets: %s."] = "Предпочтительное прокачивание питомца: %s."
	L["at least %d health"] = "как минимум %d здоровья"
	L["at least %d health (or any Magic/Mechanical)"] = "Не менее %d здоровья (или любой Магический/Механический)"
	L["at least %d health (%s damage expected)"] = "Не менее %d здоровья (%s ожидается урона))"
	L["at least %d health (or any Magic/Mechanical, %s damage expected)"] = "По крайней мере, %d здоровья (или любой Магический/Механический,ожидается урона %s)"
	L["at most %d health"] = "Не более %d здоровья"
	L["at least level %s"] = "Уровень не ниже %s"
	L["at most level %s"] = "Уровень не выше %s"
	
-- Process\SpecialSlots.lua
    L["Ignored Slot"] = "Игнорируемый слот"
	L["Teams saved with ignored slots will not load anything into these slots."] = "Если команда будет сохранена с игнорируемым слотом то в этот слот ничего не будет загружаться, а останется тот питомец который был перед этим в слоте."
	L["Teams saved with random slots will load a random high level pet into these slots."] = "Когда сохраненная команда с случайным слотом будет загружена, случайный питомец максимального уровня займёт этот слот.\n\nПредпочтение отдаётся питомцам не состоящим в какой либо команде и с полным здоровьем."
	L["Random %s Pet"] = "Случайный %s питомец"
	L["Random Pet"] = "Случайный питомец"

-- Menus\Menu.lua
	L["Help"] = "Помощь"

-- Menus\TeamMenus.lua
	L["Edit Win Record"] = "Редактировать отчёт побед"
	L["Change Name Or Target"] = "Изменить имя или цель"
	L["Edit Team"] = "Редактировать команду"
	L["Set Notes"] = "Написать или изменить заметку"
	L["Leveling Preferences"] = "Предпочтения прокачивания"
	L["Move To"] = "Переместить в"
	L["Move To Top"] = "Переместить в начало"
	L["Move Up"] = "Переместить вверх"
	L["Move Down"] = "Переместить вниз"
	L["Move To End"] = "Переместить в конец"
	L["Share"] = "Поделиться"
	L["Delete this team?"] = "Удалить эту команду?"
	L["Unload Team"] = "Выгрузить Команду"
	L["Add a leveling pet to this team?"] = "Добавить питомца для прокачивания в эту команду?"
	L["About Teams"] = "О командах"
	L["Teams named in %sWhite\124r have a target stored within them.\nTeams named in Gold do not.\n\n%sTo change pets or abilities in a team:\124r\n1) Load the team.\n2) Make any changes.\n3) Click Save at the bottom of the window."] = "Команды с %sБелым\124r именем имеют цель, хранящуюся в них. \nКоманды с Золотым именем не имеют. \n\n%sЧтобы сменить питомцев или способности в команде:\124r\n1) Загрузите команду.\n2) Сделайте любое изменение.\n3) Нажмите «Сохранить» в нижней части окна."
	L["Copy As Plain Text"] = "Копировать как простой текст"
	L["Format this team into plain text to copy elsewhere, such as forums or emails.\n\nThe plain text format is best for sharing a team with others that may not use Rematch."] = "Форматировать эту команду в обычный текст, чтобы скопировать в другое место, например, форумы или электронные письма. \n\nПростой текстовый формат лучше всего подходит для того, чтобы поделиться командой с теми, которые могут не использовать Rematch."
	L["Export Team"] = "Экспортировать команду"
	L["Export this team as a string you can copy elsewhere, such as forums or emails.\n\nOther Rematch users can paste this team into their Rematch via Import Team."] = "Экспортировать эту команду в виде строки, которую вы можете скопировать в другое место, например, форумы или электронные письма. \n\nДругие пользователи Rematch могут вставить эту команду в своём Rematch через Команды - Импортировать команду"
	L["Import Team"] = "Импортировать Команду"
	L["Import a single team or many teams that were exported from Rematch."] = "Импортировать одну команду или много команд, которые были экспортированы из Rematch."
	L["Send Team"] = "Отправить команду"
	L["Sharing is disabled in options."] = "Обмен отключен в настройках." 
	L["Send this team to another online user of Rematch."] = "Отправить эту команду другому онлайн-пользователю Rematch."
	L["Prompt To Load"] = "Запрос на загрузку"
	L["When your new target has a saved team not already loaded, and the target panel isn't on screen, display a popup asking if you want to load the team.\n\nThis is only for the first interaction with a target. You can always load a target's team from the target panel."] = "Когда ваша новая цель имеет сохраненную команду, которая еще не загружена, а целевая панель не отображается на экране, показать всплывающее окно с вопросом, хотите ли вы загрузить команду. \n\nВсплывающее окно будет показано только при первом взаимодействии с целью. Вы всегда можете загрузить команду цели с целевой панели."
	L["With Rematch Window"] = "С окном Rematch"
	L["Prompt to load with the Rematch window instead of a separate popup dialog."] = "Запросить загрузку используя окно Rematch вместо отдельного всплывающего диалогового окна."
	L["Always Prompt"] = "Всегда запрашивать"
	L["Prompt every time you interact with a target with a saved team not already loaded, instead of only the first time."] = "При взаимодействии с целью, у которой есть сохраненная команда, но она не загружена , запросить каждый раз, а не только в первый раз."
	L["When you mouseover a new target that has a saved team not already loaded, immediately load it.\n\nThis is only for the first interaction with a target. You can always load a target's team from the target panel."] = "При наведении указателя мыши на новую цель с сохраненной командой, которая ещё не загружена, немедленно загрузить ее. \n\nЗагрузка только для первого взаимодействия с целью. Вы всегда можете загрузить команду цели с целевой панели."
	L["Show After Loading"] = "Показать после загрузки"
	L["After a team auto loads, show the Rematch window."] = "После автоматической загрузки команды показать окно Rematch."
	L["Show On Injured"] = "Показать при раненых"
	L["When a team auto loads, show the Rematch window if any pets are injured."] = "При автоматической загрузке команды показать окно Rematch, если какой-либо из загруженных питомцев ранен."
	L["On Target Only"] = "Только для цели"
	L["Auto load upon targeting only, not mouseover.\n\n\124cffff4040WARNING!\124r This is not recommended! It can be too late to load pets if you target with right-click!"] = "Автоматическая загрузка только при нацеливании, а не с помощью наведения мышкой. \n\n\124cffff4040ПРЕДУПРЕЖДЕНИЕ!\124r Это не рекомендуется! Может слишком поздно загрузить питомцев, если вы выбираете цель правым щелчком мышки!"
	L["Export Listed Teams"] = "Экспорт перечисленных команд"
	L["Export all teams listed below to a string you can copy elsewhere, such as forums or emails.\n\nOther Rematch users can then paste these teams into their Rematch via Import Teams.\n\nYou can export a single team by right-clicking one and choosing its Share menu."] = "Экспортировать все команды, перечисленные ниже, в строку, которую вы можете скопировать в другое место, например, на форумы или электронные письма. \n\Другие пользователи Rematch могут затем вставить эти команды в свой Rematch через Команды - Импортировать команды. \n\nВы можете экспортировать одну команду сделав правый щелчок мышки и выбрав меню «Поделиться»."
	L["Backup All Teams"] = "Резервное копирование всех команд"
	L["This will export all teams across all tabs into text that you can paste elsewhere, such as an email to yourself or a text file someplace safe. You can later restore these teams with the Import Teams option."] = "Это будет экспортировать все команды по всем вкладкам в текст, который вы можете вставить в другое место, например, в электронное письмо для себя или в текстовый файл в надежном месте. Вы можете позже восстановить эти команды с помощью Команды - Импорт команд."
	L["Import Teams"] = "Импортировать команды"
	L["Import a single team or many teams that was exported from Rematch."] = "Импортировать одну команду или много команд, которые были экспортированы из Rematch."
	L["Import From Pet Battle Teams"] = "Импорт из Pet Battle Teams"
	L["Copy your existing teams from Pet Battle Teams to Rematch."] = "Скопировать существующие команды состоящие в аддоне Pet Battle Teams в Rematch." 

-- Menus\PetMenus.lua
	L["Unnamed Pets"] = "Не переименованные"
	L["-- Collected pets that still have their original name.\n\nreturn owned and not customName"] = "-- Собранные питомцы, у которых все еще есть свое первоначальное имя. \n\nreturn owned and not customName"
	L["Partially Leveled"] = "В очереди для прокачивания"
	L["-- Pets that have earned some xp in battle.\n\nreturn xp and xp>0"] = "-- Питомцы которые всё ещё могут получать опыт в бою питомцев.\n\nreturn xp and xp>0"
	L["Unique Abilities"] = "Уникальные способности"
	L["-- Pets with abilities not shared by other pets.\n\nif not count then\n  -- create count of each ability per species\n  count = {}\n  for speciesID in AllSpeciesIDs() do\n    for abilityID in AllAbilities(speciesID) do\n      if not count[abilityID] then\n        count[abilityID] = 0\n      end\n      count[abilityID] = count[abilityID] + 1\n    end\n  end\nend\n\nfor _,abilityID in ipairs(abilityList) do\n  if count[abilityID]==1 then\n    return true\n  end\nend"] = "-- Питомцы со способностями которых нет у других питомцев.\n\nif not count then\n  -- create count of each ability per species\n  count = {}\n  for speciesID in AllSpeciesIDs() do\n    for abilityID in AllAbilities(speciesID) do\n      if not count[abilityID] then\n        count[abilityID] = 0\n      end\n      count[abilityID] = count[abilityID] + 1\n    end\n  end\nend\n\nfor _,abilityID in ipairs(abilityList) do\n  if count[abilityID]==1 then\n    return true\n  end\nend"
	L["Pets Without Rares"] = "Питомцы не редкого качества"
	L["-- Collected battle pets that have no rare version.\n\nif not rares then\n  rares = {}\n  for petID in AllPetIDs() do\n    if select(5,C_PetJournal.GetPetStats(petID))==4 then\n      rares[C_PetJournal.GetPetInfoByPetID(petID)]=true\n    end\n  end\nend\n\nif canBattle and owned and not rares[speciesID] then\n  return true\nend"] = "-- Собранные боевые питомцы у которых нету версии редкого качества.\n\nif not rares then\n  rares = {}\n  for petID in AllPetIDs() do\n    if select(5,C_PetJournal.GetPetStats(petID))==4 then\n      rares[C_PetJournal.GetPetInfoByPetID(petID)]=true\n    end\n  end\nend\n\nif canBattle and owned and not rares[speciesID] then\n  return true\nend"
	L["Hybrid Counters"] = "Гибридные способности"
	L["-- Pets with three or more attack types different than their pet type.\n\nlocal count = 0\nfor _,abilityID in ipairs(abilityList) do\n  local abilityType,noHints = select(7, C_PetBattles.GetAbilityInfoByID(abilityID) )\n  if not noHints and abilityType~=petType then\n    count = count + 1\n  end\nend\n\nreturn count>=3\n"] = "-- Питомцы имеющие несколько видов атак, наносящих урон разным семействам питомцев.\n\nlocal count = 0\nfor _,abilityID in ipairs(abilityList) do\n  local abilityType,noHints = select(7, C_PetBattles.GetAbilityInfoByID(abilityID) )\n  if not noHints and abilityType~=petType then\n    count = count + 1\n  end\nend\n\nreturn count>=3\n"
	L["Stop Leveling This Slot"] = "Остановить прокачку этого слота"
	L["Find Similar"] = "Найти похожих"
	L["Enter a new name"] = "Введите новое имя"
	L["List %d Teams"] = "Добавлен в %d команд"
	L["Hide Pet"] = "Скрыть питомца"
	L["Unhide Pet"] = "Не скрывать питомца"
	L["Slotted pets cannot be released."] = "Питомцы загруженные в слот для битвы не могут быть выпущены на волю."
	L["Release this pet?"] = "Отпустить на волю этого питомца?"
	L["Once released, this pet is gone forever!"] = "После выпуска, этот питомец уйдёт навсегда!"
	L["Slotted pets cannot be caged."] = "Питомцы загруженные в слот для битв нельзя посадить в клетку."
	L["Injured pets cannot be caged."] = "Питомцев с неполным здоровьем нельзя посадить в клетку."
	L["Cage this pet?"] = "Посадить в клетку этого питомца?"
	L["Start Leveling"] = "Начать прокачивание"
	L["Add To Leveling Queue"] = "Добавить в очередь прокачивания"
	L["Stop Leveling"] = "Удалить из очереди прокачивания"
	L["Only Favorites"] = "Только Избранные"
	L["Favorite Filters"] = "Избранные фильтры"
	L["Pet Filter"] = "Фильтр питомцев"
	L["In addition to the filters in this menu, you can further refine the pet list with the search box. Some search examples:\n\nPets: %sBlack Tabby\124r\nZones: %sSilithus\124r\nAbilities: %sSandstorm\124r\nText in abilities: %sBleed\124r\nLevels: %slevel=21-23\124r\nStats: %sspeed>300\124r\n\nSearches in \"quotes\" will limit results to only complete matches.\n\nSearch results will be sorted by relevance unless the option %sDon't Sort By Relevance\124r is checked in the Options tab."] = "В дополнение к фильтрам можно так же указать определённые характеристики питомца в окне поиска. Некоторые примеры поиска:\n\nПитомец: %sСерая полосатая кошка\124r\nЗона: %sСилитус\124r\nСпособности: %sПесчаная буря\124r\nТекст в способностях: %sКровотечение\124r\nУровень: %slevel=21-23\124r\nХарактеристика: %sspeed>300\124r\n\nSearches in \"quotes\" will limit results to only complete matches.\n\nSearch results will be sorted by relevance unless the option %sНе сортировать по актуальности\124r is checked in the Options tab."
	L["Reset All"] = "Сбросить все"
	L["Checkbox Groups"] = "Группы флажков"
	L["In filter menus, checkbox groups assume if nothing is checked you want to view all choices.\n\nYou can also:\n\n%s[Shift]+Click\124r to check all except the box clicked.\n\n%s[Alt]+Click\124r to uncheck all except the box clicked."] = "В меню фильтров группы флажков предполагают, что если ничего не было отмечено, вы хотите просмотреть все варианты. \n\nВы можете также: \n\n%s[Shift]+Click\124r, чтобы отметить все, кроме того куда наведён курсор. \n\n%s[Alt]+Click\124r, чтобы снять флажок, кроме того куда наведён курсор."
	L["Low Level (1-7)"] = "Низкий уровень (1-7)"
	L["Mid Level (8-14)"] = "Средний уровень (8-14)"
	L["High Level (15-24)"] = "Высокий уровень (15-24)"
	L["Max Level (25)"] = "Максимальный уровень (25)"
	L["Without Any 25s"] = "Без любых 25"
	L["Moveset Not At 25"] = "Набор атак не на 25"
	L["You can filter to a specific level or range of levels in the search box. For example, search for:\n\n\%slevel=1\124r\nor\n\%slevel=21-23\124r"] = "Вы можете отфильтровать до определенного уровня или диапазона уровней в окне поиска. Например, выполните поиск: \n\n\%slevel=1\124r\nили\n\%slevel=21-23\124r"
	L["All breed data is pulled from your installed %s%s\124r addon.\n\nThe breed \"New\" categorizes pets with no breed data. Keep your breed addon up to date to see if they have new data."] = "Все данные о породе берутся из вашего установленного %s%s\124r аддона.\n\nПитомец отмеченный \"New\" классифицируется без данных о породе. Держите аддон для определения породы включенным, чтобы узнать, есть ли у них новые данные."
	L["Not Leveling"] = "Не прокачивать"
	L["Not Tradable"] = "Нельзя продать"
	L["Can Battle"] = "Для битв"
	L["Can't Battle"] = "Не для битв"
	L["One Copy"] = "Одна копия"
	L["Two+ Copies"] = "Две+ копии"
	L["Three+ Copies"] = "Три+ копии"
	L["In A Team"] = "В команде"
	L["Not In A Team"] = "Не в команде"
	L["Current Zone"] = "Текущая зона"
	L["Hidden Pets"] = "Скрытый питомец"
	L["Has Notes"] = "Имеет заметки"
	L["Reverse Sort"] = "Обратная сортировка"
	L["Favorites First"] = "Избранное с начало"
	L["Sort By"] = "Сортировать по"
	L["You can filter to a specific range of stats too. For example, search for:\n\n\%shealth>500\124r\nor\n\%sspeed=200-300\124r\n\nThe sort order is not ordinarily reset when filters are reset. The option %sReset Sort With Filters\124r in the Options tab will reset the sort when you reset the filters."] = "Вы также можете отфильтровать определенный диапазон характеристик. Например, выполните поиск: \n\n\%shealth>500\124r\nили\n\%sspeed=200-300\124r\n\nПорядок сортировки обычно не сбрасывается при сбросе фильтров. Опция %sСбросить сортировку с фильтрами\124r на вкладке «Настройки» сбросит сортировку при сбросе фильтров."
	L["Find Pets With This Ability"] = "Найти питомцев с этой способностью"
	L["Hide this pet?"] = "Скрыть этого питомца?"
	L["Don't Ask When Hiding Pets"] = "Не спрашивать при скрытии питомца"
	L["Are you sure you want to hide all versions of %s%s\124r?\n\nHidden pets will not show up in the pet list or searches. You can view or unhide these pets in the 'Other' filter."] = "Вы уверены, что хотите скрыть все версии %s%s\124r?\n\n Скрытые питомцы не будут отображаться в списке питомцев или в результатах поиска. Вы можете просмотреть или отобразить этих питомцев в фильтре «Другое»."
	L["Save Filter"] = "Сохранить фильтр"
	L["A filter must be active before it can be saved."] = "Фильтр должен быть активным до его сохранения."
	L["Save this as a favorite filter?"] = "Сохранить это как избранный фильтр?"
	L["Filters: %s%s\124r\n\nChoose a name to use in the Favorite Filters menu:"] = "Фильтры:%s%s\124r\n\n Выберите имя для использования в меню «Избранные фильтры»:"
	L["Note: Search text and Sort order are not included in the filter."] = "Примечание: текст поиска и порядок сортировки не включен в фильтр."
	L["Delete Filter"] = "Удалить фильтр"
	L["Are you sure you want to delete the filter named %s%s\124r?"] = "Вы действительно хотите удалить фильтр с именем%s%s\124r?"
	L["New Script"] = "Новый скрипт"
	L["Create a new pet filter."] = "Создать новый фильтр для боевых питомцев."
	L["Script Filters"] = nil
	L["This allows you to create custom pet filters with a little bit of Lua code. See the reference buttons at the top of the New Script dialog for details.\n\nTo view or edit an existing script, click the Gear icon beside the script in the menu above."] = "Это позволяет создавать пользовательские фильтры для питомцев с небольшим количеством кода Lua. Подробнее см. В справочных кнопках в верхней части диалогового окна «Новый скрипт». \n\nЧтобы просмотреть или отредактировать существующий скрипт, нажмите значок шестерни рядом с скриптом в меню выше."
	L["Delete Script"] = "Удалить скрипт"
	L["Are you sure you want to delete the script named %s%s\124r?"] = "Вы действительно хотите удалить скрипт с именем %s%s\124r"
    L["Ignore This Slot"] = "Игнорировать этот слот"
	L["Put Random Pet Here"] = "Поместить случайного питомца здесь"
	L["Put Leveling Pet Here"] = "Поместить питомца для прокачивания здесь"
	L["Stop Leveling This Slot"] = "Остановить прокачивание для этого слота"
	L["Stop Randomizing This Slot"] = "Остановить выбор случайного питомца для этого слота"
	L["Stop Ignoring This Slot"] = "Прекратить игнорировать этот слот"
	L["Any Type"] = "Любой тип"
	L["Unique Moveset"] = "Уникальный набор атак"
	L["Find Moveset"] = "Найти набор атак"
	L["Shared Moveset"] = "Совместный набор атак"

-- Menus\Npcs.lua
	L["Imported Team"] = "Импортировать команду"
	L["Deadmines"] = "Мертвые копи"
	L["Eastern Kingdom"] = "Восточные Королевства"
	L["Kalimdor"] = "Калимдор"
	L["Outland"] = "Запределье"
	L["Northrend"] = "Норсдскол"
	L["Cataclysm"] = "Cataclysm"
	L["Pandaria"] = "Пандария"
	L["Beasts of Fable"] = "Звери из легенд"
	L["Celestial Tournament"] = "Турнир небожителей"
	L["Draenor"] = "Дренор"
	L["Garrison"] = "Гарнизон"
	L["Menagerie"] = "Зверинец"
	L["Tanaan Jungle"] = "Танаанские Джунгли"
	L["Val'sharah"] = "Вальшара"
	L["Suramar"] = "Сарумар"
	L["Stormheim"] = "Штормхейм"
	L["Highmountain"] = "Крутогорье"
	L["Dalaran"] = "Даларан"
	L["Azsuna"] = "Азсуна"
	L["Broken Isle"] = "Расколотый Берег"
	L["Wailing Caverns"] = "Пещеры Стенаний"
	L["No Target"] = "Нет цели"
	L["Noteworthy Targets"] = "Заслуживающие внимания цели"
	L["These are noteworthy targets such as tamers and legendary pets.\n\nChoose one to view the pets you would battle.\n\nTargets with a \124TInterface\\RaidFrame\\ReadyCheck-Ready:14\124t already have a team saved."] = "Это заслуживающие внимания цели, такие как укротители и легендарные питомцы. \n\nВыберите цель что бы просмотреть питомцев которые входят в её команду или собрать команду для битвы с ней, после того как команда будет собрана нажмите «Сохранить» в верхней части окна. \n\nЦели отмеченные \124TInterface\\RaidFrame\\ReadyCheck-Ready:14\124t уже имеют команду."

-- Dialogs\Dialog.lua
	L["Tab:"] = "Вкладка:"

-- Cards\PetCard.lua
	L["Damage\nTaken"] = "Получаемый\nурон"
	L["from"] = "от"
	L["abilities"] = "способностей"
	L["Unpin Pet Card"] = "Прикрепить карточку питомца"
	L["While pinned, the pet card will display where you last moved it.\n\nClick this to unpin the pet card and snap it back to the pets."] = "Когда карточка питомца не закреплена она будет показана где вы в последний раз перемещали её. \n\nНажмите здесь, чтобы привязать карточку к питомцам."
	L["Pet Card"] = "Карточка питомца"
	L["Hold [Alt] to view more about this pet."] = "Удерживайте [Alt], чтобы больше узнать об этом питомце."
	L["XP: %d/%d (%d%%)"] = nil
	L["Possible Breeds"] = "Возможные породы"
	L["Slotted"] = "В слоте"
	L["This pet is loaded in one of the three battle pet slots."] = "Этот питомец загружен в одном из трех игровых слотов для битвы."
	L["Favorite"] = "Избранный"
	L["This pet is marked as a Favorite from its right-click menu."] = "Это питомец помечен как «Избранное» из его меню правой кнопки мыши."
	L["This pet is in Rematch's leveling queue."] = "Этот питомец находится в очереди прокачивания Rematch."
	L["Determines how stats are distributed.  All breed data is pulled from your installed %s%s\124r addon."] = "Определяет распределение характеристик породы. Все данные породы берутся из установленного аддона %s%s\124."
	L["Species ID"] = nil
	L["All versions of this pet share this unique \"species\" number."] = nil
	L["%d Teams"] = "%d Команд"
	L["Teams"] = "Команды"
	L["%s Click to search for all teams that include this pet."] = "%s Нажмите, чтобы найти все команды, в которых состоит этот питомец."
	L["%s Click to search for all versions of this pet."] = "%s Нажмите, чтобы найти все версии этого питомца."
	L["When this team loads, your current leveling pet will go in this spot."] = "Когда эта команда будет загружена, ваш питомец для прокачивания займёт это место."
	L["This is an opponent pet."] = "Это питомец противника"
	L["All breed data pulled from %s%s\124r."] = "Все данные породы выведены из %s%s\124r."
	L["Stats At Level 25 \124cff0070ddRare"] = "Характеристики на уровне 25 \124cff0070ddRare"
	L["No known breeds :("] = "Нет известных пород :("
	L["When this team loads, this spot will be ignored."] = "Когда команда будет загружена, этот слот будет проигнорирован и в этом слоте останется тот питомец который загружен в текущий момент в этот слот."
	L["When this team loads, a random high level pet will go in this spot."] = "Когда команда будет загружена, этот слот займёт случайный питомец максимального уровня."

-- Cards\AbilityCard.lua
	L["Vs"] = nil

-- Cards\Notes.lua
	L["Pet Notes"] = "Заметка питомца"
	L["Delete Notes"] = "Удалить заметку"
	L["Are you sure you want to delete the notes for %s\124r?"] = "Вы действительно хотите удалить заметки для %s\124r?"

-- Cards\WinRecord.lua
	L["Win Record"] = "Статистика побед"
	L["Hold [Alt] to view totals for all teams."] = "Удерживайте [Alt], \nчтобы просмотреть итоговые значения для всех команд."
	L["Wins:"] = "Побед:"
	L["Losses:"] = "Поражений:"
	L["Draws:"] = "Ничьи:"
	L["Totals Across All Teams"] = "Итого по всем командам"
	L["%s%s\124r Battles"] = "%s%s\124r Боёв"
	L["+1 Win"] = "+1 Победа"
	L["+1 Loss"] = "+1 Поражение"
	L["+1 Draw"] = "+1 ничья"
	L["Reset Win Record"] = "Сбросить Статистику побед"
	L["Are you sure you want to remove all wins, losses and draws from the team \"%s\"?"] = "Вы уверены, что хотите удалить все победы, потери и ничьи для команды \"%s\"?"
	L["Reset All Win Records"] = "Сбросить всю Статистику побед"
	L["Are you sure?"] = "Вы уверены?"
	L["This will remove win record data for all teams and cannot be undone!"] = "Это приведет к удалению данных о статистике побед для всех команд и не может быть восстановлено!"
	L["Convert Team Names To Win Records"] = "Преобразовать имена команд для записи статистики побед"
	L["Convert"] = "Конвертировать"
	L["This will look for teams with names that may include win-loss-draw stats and pull those into an actual win record before removing the numbers from the team name.\n\nDo you want to convert these teams?\n\nThe currently loaded team will be unloaded to prevent major complications.\n\n\124cffff1111Please backup your teams before attempting this!"] = "Это будет искать команды с именами, которые могут включать статистику побед и вытащит их в фактическую запись побед, прежде чем удалять номера из имени команды. \n\nВы хотите преобразовать эти команды? \ N \ nЗагруженная в текущий момент Команда будет выгружена для предотвращения серьезных осложнений. \n\n\124cffff1111Пожалуйста, сделайте резервную копию своих команд, прежде чем пытаться это сделать!"
	L["Done!"] = "Готово!"
	L["%s%d teams and %d battles were converted."] = "%S%d команд и %d битвы были преобразованы."

-- Panels\PetPanel.lua
	L["Strong vs"] = "Сильный против"
	L["Tough vs"] = "Устойчивые к"
	L["Pets: %s%d"] = "Питомец: %s%d"
	L["Filters: %s%s"] = "Фильтры:  %s%s"

-- Panels\LoadoutPanel.lua
	L["Target has a saved team"] = "У цели есть сохраненная команда"
	L["Load"] = "Загрузка"
	L["Load the team saved for this target."] = "Загрузить команду, сохраненную для этой цели."
	L["This target has no saved team"] = "У этой цели нет сохраненной команды"
	L["Save the currently loaded pets to this target."] = "Сохранить загруженных в данный момент питомцев для этой цели."

-- Panels\TeamPanel.lua
    L["Loaded Team"] = "Загруженная команда"

-- Panels\QueuePanel.lua
	L["Ascending Level"] = "Низкий уровень"
	L["Descending Level"] = "Высокий уровень"
	L["Median Level"] = "Средний уровень"
	L["Type"] = "Тип"
	L["Queue"] = "Очередь"
	L["This is the leveling queue. Drag pets you want to level here.\n\nRight click any of the three battle pet slots and choose 'Put Leveling Pet Here' to mark it as a leveling slot you want controlled by the queue.\n\nWhile a leveling slot is active, the queue will fill the slot with the top-most pet in the queue. When this pet reaches level 25 (gratz!) it will leave the queue and the next pet in the queue will take its place.\n\nTeams saved with a leveling slot will reserve that slot for future leveling pets."] = "Это очередь прокачивания. Перетащите суда боевых питомцев, которых вы хотите прокачать. \n\nКогда сохранённая команда будет загружена питомец из очереди прокачивания займет свое место. \n\Когда питомец достигает уровня 25 (gratz!),он выйдет из очереди, а следующий питомец в очереди встанет на его место."
	L["Sort by:"] = "Сортировать по:"
	L["Sort all pets in the queue from level 1 to level 24."] = "Отсортировать всех питомцев в очереди от уровня 1 до уровня 24."
	L["Sort all pets in the queue for levels closest to 10.5."] = "Сортировка всех питомцев в очереди для уровней, близких к 10.5."
	L["Sort all pets in the queue from level 24 to level 1."] = "Сортировка всех питомцев в очереди от уровня 24 до уровня 1."
	L["Sort all pets in the queue by their types."] = "Сортировка всех питомцев в очереди по их типам."
	L["Group favorites to the top of the queue."] = "Избранные группы в начале очереди"
	L["Rares First"] = "Сначала редкие"
	L["Group rares to the top of the leveling queue."] = "Группы редких питомцев в начало очереди прокачивания"
	L["Active Sort"] = "Активная сортировка"
	L["The queue will stay sorted in the order chosen. The order of pets may automatically change as they gain xp or get added/removed from the queue.\n\nYou cannot manually change the order of pets while the queue is actively sorted."] = "Очередь будет отсортирована в выбранном порядке. Порядок питомцев будет автоматически изменяться по мере того, как он будут получать опыт или добавляются/удаляются из очереди. \n\nВы не можете вручную изменить порядок питомцев, пока очередь активно сортируется."
	L["Pause Preferences"] = "Приостановить предпочтения"
	L["Suspend all preferred loading of pets from the queue, except for pets that can't load."] = "Приостановить всю предпочтительную загрузку питомцев из очереди, за исключением питомцев, которые не могут загрузится."
	L["Fill Queue"] = "Заполнить очередь"
	L["Fill the leveling queue with one of each version of a pet that can level from the filtered pet list, and for which you don't have a level 25 or one in the queue already."] = "Заполнить очередь прокачивания одной из каждой версии питомца, которая может прокачатся из списка фильтра питомцев и для которого у вас нет уровня 25 и ни одного в очереди."
	L["Fill Queue More"] = "Заполнить очередь всеми питомцами"
	L["Fill the leveling queue with one of each version of a pet that can level from the filtered pet list, regardless whether you have any at level 25 or one in the queue already."] = "Заполнить очередь прокачивания одной из каждой версии питомца, которая может прокачатся из списка фильтра питомцев, независимо от того, есть ли у вас 25 уровня или есть в очереди."
	L["Empty Queue"] = "Очистить очередь"
	L["Remove all leveling pets from the queue."] = "Удалить всех прокачивающихся питомцев из очереди."
	L["Are you sure you want to remove all pets from the leveling queue?"] = "Вы уверены, что хотите удалить всех питомцев из очереди прокачивания?"
	L["Leveling Queue"] = "Очередь прокачивания"
	L["No Active Sort"] = "Нет активной сортировки"
	L["Turn off Active Sort. Queued pets can then be rearranged and will not automatically reorder themselves.\n\nTo turn Active Sort back on, check %sActive Sort\124r in the Queue menu."] = "Отключить Активную Сортировку. Очередь питомцев может быть перегруппирована и не будет автоматически пере упорядочиваться. \n\nЧтобы включить Активную сортировку, проверьте %sАктивную Сортировку\124r в меню «Очередь."
	L["Turn Off Active Sort?"] = "Отключить активную сортировку?"
	L["Leveling Pets: %s%s"] = "Всего в очереди: %s%s"
	L["Active Sort:"] = "Активная сортировка:"
	L["Add these pets to the queue?"] = "Добавить этого питомца в очередь?"
	L["This will add %s%d\124r pets to the leveling queue.\n\nYou can be more selective by filtering pets.\n\nFor instance, if you filter pets to High Level (15-24) and Rare, Fill Queue will only add rare pets between level 15 and 24."] = "Это добавит %s%d\124r питомцев в очередь прокачивания. \n\nВы можете быть более избирательными, фильтруя питомцев. \n\nВ случае, если вы фильтруете питомцев на высокий уровень (15-24) и Редкое, в очередь будут добавляться только редкие питомцы между 15 и 24 уровнями."
	L["This will add %s%d\124r pets to the leveling queue."] = "Это добавит %s%d\124r питомцев в очередь прокачивания."
	L["This pet is already in the queue and Active Sort is enabled.\n\nWhile enabled, the queue has complete control over the order of pets in the queue.\n\nDo you want to turn off Active Sort to move this pet in the queue?"] = "Этот питомец находится в очереди прокачивания и Активная сортировка включена.\n\nКогда включена Активная сортировка, очередь прокачивания полностью управляется питомцами из очереди прокачивания.\n\nВы хотите отключить Активную сортировку чтобы переместить этого питомца в очередь?"
	L["Current Leveling Pet"] = "Текущий прокачиваемый питомец" 

-- Panels\MiniQueue.lua

-- Panels\MiniPanel.lua
	L["This target has a saved team"] = "Эта цель имеет сохраненную команду"

-- Panels\OptionPanel.lua
	L["All Options"] = "Все настройки"
	L["Targeting Options"] = "Параметры цели"
	L["Auto load upon targeting only, not mouseover.\n\n\124cffff4040WARNING!\124r This is not recommended! It can be too late to load pets if you target with right click!"] = "Автоматическая загрузка только с таргетингом, а не с помощью наведения мышкой. \n\n\124cffff4040ПРЕДУПРЕЖДЕНИЕ!\124r Это не рекомендуется! Слишком поздно загрузит питомцев, если вы выбираете цель правым кликом!"
	L["Always Show When Targeting"] = "Всегда показывать при взятии в цель"
	L["Regardless whether a target's team is already loaded, show the Rematch window when you target something with a saved team."] = "Независимо от того, загружена ли команда цели, показывает окно Rematch, когда вы берёте в цель NPC с сохраненной командой."
	L["Preferred Window Mode"] = "Предпочтительный режим окна"
	L["Minimized Standalone"] = "Минимизированный автономный"
	L["When automatically showing the Rematch window, show the minimized standalone window."] = "Когда автоматически показывается окно Rematch, показать минимальное отдельное окно."
	L["Maximized Standalone"] = "Максимизированный автономный"
	L["When automatically showing the Rematch window, show the maximized standalone window."] = "Когда автоматически показывается окно Rematch, показать максимальное отдельное окно."
	L["Pet Journal"] = "Атлас питомцев"
	L["When automatically showing the Rematch window, show the pet journal."] = "Когда автоматически показывается окно Rematch, показать Атлас питомцев"
	L["Standalone Window Options"] = "Параметры Автономного окна"
	L["Use Custom Scale"] = "Пользователький масштаб"
	L["Change the relative size of the standalone window to anywhere between 50% and 200% of its standard size."] = "Изменить относительный размер отдельного окна в любом диапазоне от 50% до 200% от его стандартного размера."
	L["Single Panel Mode"] = "Режим одиночной панели"
	L["Collapse the maximized standalone window to one panel instead of two side by side.\n\nUsers of earlier versions of Rematch may find this mode more familiar."] = "Свернуть максимальное Автономное окно на одну панель вместо двух бок о бок. \n\nИспользование более ранних версий Rematch может найти этот режим более знакомым."
	L["Combine Pets And Queue"] = "Объединение питомцев и очереди"
	L["In single panel mode, combine the Pets and Queue tabs together. A narrow queue will display to the right of the pet list instead of in a separate tab."] = "В режиме одной панели объединить вкладки Питомцев и Очередь вместе. Узкая очередь будет отображаться справа от списка питомцев, а не на отдельной вкладке."
	L["Keep Window On Screen"] = "Сохранить окно на экране"
	L["Don't hide the standalone window when the ESCape key is pressed or most other times it would hide, such as going to the game menu."] = "Не скрывать Автономное окно при нажатии клавиши ESCape или в большинстве случаев, когда оно скрывается, например, в меню игры."
	L["Even For Pet Battles"] = "Даже во время битвы питомцев"
	L["Keep the standalone window on the screen even when you enter pet battles."] = "Сохранять отдельное окно на экране, даже когда вы входите в битву питомцев."
	L["Even Across Sessions"] = "Даже через сеансы"
	L["If the standalone window was on screen when logging out, automatically summon it on next login."] = "Если Автономное окно было на экране при выходе из системы, автоматически вызывать его при следующем входе в систему."
	L["Don't Minimize With ESC Key"] = "Не сворачивать с помощью клавиши ESC"
	L["Don't minimize the standalone window when the ESCape key is pressed."] = "Не сворачивать Автономное окно при нажатии клавиши ESCape."
	L["Or With Panel Tabs"] = "Или с вкладками панели"
	L["Don't let the Pets, Teams, Queue or Options tabs minimize the standalone window."] = "Не позволять вкладкам Питомцы, Команды, Очередь или Параметры сводить к минимуму Автономное окно."
	L["Lower Window Behind UI"] = "Нижнее окно за пользовательским интерфейсом"
	L["Push the standalone window back behind other parts of the UI so other parts of the UI can appear ontop."] = "Переместить Автономное окно назад за другими частями пользовательского интерфейса, чтобы другие части пользовательского интерфейса могли отображаться сверху."
	L["Move Panel Tabs To Right"] = "Перемещение вкладок панели вправо"
	L["Align the Pets, Teams, Queue and Options tabs to the right side of the standalone window."] = "Выровнять вкладки Питомец, Команды, Очередь и Параметры в правой части Автономного окна."
	L["Minimal Minimized Window"] = "Минимальное минимизированное окно"
	L["Remove the titlebar and tabs when the standalone window is minimized."] = "Удалить строку заголовка и вкладки, когда отдельное окно сведено к минимуму."
	L["Appearance Options"] = "Варианты внешнего вида"
	L["Compact List Format"] = "Формат компактного списка"
	L["Use an alternate style of lists for Pets, Teams and Queue to display more on the screen at once.\n\n\124cffff4040This option requires a Reload."] = "Использовать альтернативный стиль списков для питомцев, команд и очереди, чтобы отображать больше на экране сразу. \n\n\124cffff4040Этот параметр требует перезагрузки интерфейса."
	L["Use Smaller Text Too"] = "Использование меньшего текста"
	L["Also use smaller text in the Compact List Format so more text displays on each button."] = "Также использовать меньший текст в формате Компактного списка, чтобы на каждой кнопке отображалось больше текста."
	L["Color Pet Names By Rarity"] = "Имена питомцев по качеству питомца"
	L["Make the names of pets you own the same color as its rarity. Blue for rare, green for uncommon, etc."] = "Сделать имена питомцев, в тот же цвет, что и его редкость. Синий для редких, зеленых для необычных и т.д."
	L["Hide Rarity Borders"] = "Скрыть Rarity границы"
	L["Don't color the icon border for pets you own in the same color as its rarity."] = "Не окрашивать границу значка для питомца, которыми вы владеете, в том же цвет, что и его редкость."
	L["Hide Level At Max Level"] = "Скрыть уровень на максимальном уровне"
	L["If a pet is level 25, don't show its level on the pet icon."] = "Если питомец 25 уровня, не показывать его уровень на значке питомца."
	L["Show Ability Numbers"] = "Показать номера способностей"
	L["In the ability flyout, show the numbers 1 and 2 to help with the common notation such as \"Pet Name 122\" to know which abilities to use."] = "В раскрывающемся списке возможностей указать номера 1 и 2, чтобы помочь с общим обозначеним, таким как \"Имя Питомца 122\" чтобы узнать, какие способности использовать."
	L["On Loaded Abilities Too"] = "О загруженных способностях тоже."
	L["Toolbar Options"] = "Параметры панели инструментов"
	L["Move Toolbar To Bottom"] = "Переместить панель инструментов в нижнюю часть"
	L["Move the toolbar buttons (Revive Battle Pets, Battle Pet Bandages, Safari Hat, etc) to the bottom of the standalone window.\n\nAlso convert the red panel buttons (Save, Save As, Find Battle) to toolbar buttons."] = "Переместить кнопки панели инструментов (Воскрешение, Бинты для боевых питомцев, Шляпа для сафари и т.д.) в нижнюю часть отдельного окна. \n\nТакже преобразовать кнопки панели красного цвета (Сохранить, Сохранить как, Вступить в битву) на кнопки панели инструментов."
	L["Reverse Toolbar Buttons"] = "Обратить кнопки панели инструментов"
	L["Reverse the order of the toolbar buttons (Revive Battle Pets, Battle Pet Bandages, Safari Hat, etc)."] = "Обратить порядок кнопок на панели инструментов (Воскрешение, Бинты для боевых питомцев, Шляпа для сафари и т.д)."
	L["Hide On Toolbar Right Click"] = "Скрыть панель инструментов правой кнопкой мыши"
	L["When a toolbar button is used with a right click, dismiss the Rematch window after performing its action."] = "Когда вы нажимаете правой кнопкой по панели инструментов, отключить окно Rematch после выполнения его действия."
	L["Safari Hat Reminder"] = "Напоминание о Шляпе для сафари"
	L["Draw attention to the safari hat button while a pet below max level is loaded.\n\nAlso show the Rematch window when a low level pet loads and the safari hat is not equipped."] = "Обратить внимание на кнопку Шляпы для сафари, когда в загреженной команде имеется питомец не максимального уровня. \n\nТакже показать окно Rematch, когда загружается питомец низкого уровня, а Шляпа для сафари не одета."
	L["Pet Card & Notes Options"] = "Параметры карточки для питомцев и примечаний"
	L["Allow Pet Cards To Be Pinned"] = "Разрешить свободное перемещение карточек для питомцев"
	L["When dragging a pet card to another part of the screen, pin the card so all future pet cards display in the same spot, until the pet card is moved again or the unpin button is clicked."] = "При перетаскивании карточки питомца в другую часть экрана, прикрепить карточку так, чтобы все будущие карточки питомцев отображались в одном и том же месте, пока карточка питомца не будет перемещена или не будет нажата кнопка Прикрепить карточку питомца."
	L["Click For Pet Cards & Notes"] = "Нажатие на карточку питомца и заметок"
	L["Instead of automatically showing pet cards and notes when you mouseover them, require clicking the pet or notes button to display them."] = "Вместо автоматического отображения карточек и заметок для питомцев, когда вы наводите на них курсор, вам нужно нажать на питомца или заметки, чтобы отобразить их."
	L["Faster Pet Cards & Notes"] = "Быстрые карточки для питомцев и заметки"
	L["Instead of a small delay before showing pet cards and notes, immediately show them as you mouseover pets and notes buttons."] = "Вместо небольшой задержки перед показом карточек и заметок для питомцев, немедленно показать их, как вы наведёте курсор на питомца или кнопку заметок."
    L["Use Pet Cards In Battle"] = "Использовать карточку питомца в битве"
	L["Use the pet card on the unit frames during a pet battle instead of the default tooltip."] = "Использовать Карточку питомца на рамах во время битвы питомцев вместо всплывающей подсказки по умолчанию."
	L["Use Pet Cards For Links"] = "Использовать карточку питомца для ссылок"
	L["Use the pet card when viewing a link of a pet someone else sent you instead of the default link."] = "Использовать карточку питомца при просмотре ссылки питомца, которого кто-то отправил вместо ссылки по умолчанию."
	L["Show Team Cards"] = "Показать карточку команды"
	L["Show a card with team details when you mouseover a team.\n\n%sIMPORTANT:\124r While this option is enabled, clicking a team will lock the team card instead of loading it. %sDouble-Click\124r to load a team with this option enabled, just as you would Double-Click a pet to summon it."] = "Показать карточку с информацией о команде, когда вы наведете команду на команду. \n\n%sIMPORTANT:\124r Пока эта опция включена, щелчок команды заблокирует карточку команды, а не загружает ее.%sDouble-Click\124r для загрузки Команда с этой опцией включена, так же, как вы дважды щелкнете питомца, чтобы вызвать его."
	L["Keep Notes On Screen"] = "Сохранять заметки на экране"
	L["Don't hide notes when the ESCape key is pressed or other times it would hide, such as changing tabs or closing Rematch."] = "Не скрывть заметки при нажатии клавиши ESCape или в других случаях, когда она будет скрываться, например, изменение вкладок или закрытие Rematch."
	L["Show Notes Upon Targeting"] = "Показать заметки после выбора цели"
	L["When your target has a saved team with notes, automatically display and lock the notes."] = "Когда ваша цель имеет сохраненную команду с заметками, автоматически отобразить и закрепить на экране заметку."
	L["Show Notes In Battle"] = "Показать заметки в битве"
	L["If the loaded team has notes, display and lock the notes when you enter a pet battle."] = "Когда вы входите в битву с питомцами, если у загруженной команды есть заметки, отобразить и закрепить на экране до выхода из боя питомцев."
	L["Only Once Per Team"] = "Только один раз за команду"
	L["Only display notes automatically the first time entering battle, until another team is loaded."] = "Автоматически отображать заметки при первом входе в битву, пока не будет загружена другая команда."
	L["Alternate Lore Font"] = "Альтернативный шрифт Lore"
	L["Use a more normal-looking font for lore text on the back of the pet card."] = "Использовать стандартный шрифт для текста справки на обратной стороне карточки питомцев."
	L["Show Species ID On Pet Cards"] = "Показать Species ID на карточке питомца"
	L["Display the numerical species ID of a pet as a stat on their pet card."] = nil
	L["Team Options"] = "Параметры команды"
	L["Load Healthiest Pets"] = "Загрузка более полезных питомцев"
	L["When a team loads, if any pet is injured or dead and there's another version with more health \124cffffffffand identical stats\124r, load the healthier version.\n\nPets in the leveling queue are exempt from this option.\n\n\124cffffffffNote:\124r This is only when a team loads. It will not automatically swap in healthier pets when you leave battle."] = "Когда команда загружается и какой-либо питомец с неполным здоровьем или мёртв и есть другая версия с большим здоровьем \124cffffffffи идентичными статами\124r, то загрузить здорового питомца. \n\nПитомцы в очереди прокачивания освобождаются от этого выбора.\n\n\124cffffffffПримечание:\124r только когда  загружается команда. Это автоматически не обменивает более здоровых питомцев, когда Вы покидаете сражение."
	L["Hide Targets Below Teams"] = "Скрыть цели ниже команд"
	L["Hide the target name that appears beneath a team that is not named the same as its target."] = "Скрыть имя которое появляется под названием команды, если команда имеет эту же цель для битвы."
	L["Always Show Team Tabs"] = "Всегда показывать вкладки команды"
	L["Show team tabs along the right side of the window even if you're not on the team panel."] = "Показывать вкладки команды в правой части окна, даже если они находятся на панели команд."
	L["Move Team Tabs To Left"] = "Переместить вкладки команды влево"
	L["Move the team tabs along the right side of the standalone window to the left side."] = "Переместить вкладки команды с правой стороны Автономного окна в левую сторону."
	L["Auto Track Win Record"] = "Автоматическая запись статистики побед"
	L["At the end of each battle, automatically record whether the loaded team won or lost.\n\nForfeits always count as a loss.\n\nYou can still manually update a team's win record at any time."] = "В конце каждой битвы автоматически записывать, победила или проиграла загруженную команду. \n\nЕсли Вы покидаете бой не завершив его это засчитывается как поражение.\n\nВы можете вручную обновить отчет о победе команды в любое время."
	L["For PVP Battles Only"] = "Только для PVP битв"
	L["Automatically track whether the loaded team won or lost only in a PVP battle and never for a PVE battle."] = "Автоматически отслеживать, побеждала или проигрывалась загруженная команда только в битве PVP и не отслеживать в PVE."
	L["Display Total Wins Instead"] = "Показывать итоговые победы вместо этого"
	L["Instead of displaying the win percentage of a team on the win record button, display the total number of wins.\n\nTeam tabs that are sorted by win record will sort by total wins also."] = "Вместо того, чтобы отображать процент побед команды на кнопке записи, показать общее количество побед. \n\nВыбранные вкладки, отсортированные по записи побед, будут сортироваться по итоговым победам."
	L["Hide Win Record Buttons"] = "Скрыть кнопку статистика побед"
	L["Hide the win record button displayed to the right of each team.\n\nYou can still manually edit a team's win record from its right-click menu and automatic tracking will continue if enabled."] = "Скрыть кнопку записи побед, отображаемую справа от каждой команды. \n\nВы можете вручную отредактировать запись побед команды в меню правой кнопки мыши, и автоматическое отслеживание продолжится, если включено."
	L["Share In Legacy Format"] = "Старый формат отправки данных"
	L["When exporting teams or sending to another Rematch user, use the old format.\n\nUse this option when sharing teams with someone on an older Rematch that's unable to import or receive newer teams."] = "При экспорте команд или отправке другому пользователю Rematch использовать старый формат. \n\nИспользуйте этот параметр при совместном использовании команд с кем-то из более раннего Rematch, который не может импортировать или получать новые команды."
	L["Prioritize Breed On Import"] = "Приоритет породы при импорте."
	L["When importing or receiving teams, fill the team with the best matched breed as the first priority instead of the highest level."] = "Импортируя или принимая команды, заполнять команду такой же породой как первоначальная,вместо высшего уровня."
	L["Leveling Queue Options"] = "Параметры очереди прокачивания"
	L["Prefer Living Pets"] = "Умная прокачка."
	L["When loading pets from the queue, skip dead pets and load living ones first."] = "При загрузке питомцев из очереди, пропускать мертвых питомцев и загружать живых."
	L["And At Full Health"] = "Учитывать здоровье"
	L["Also prefer uninjured pets when loading pets from the queue."] = "Также предпочитать питомцев  с полным здоровьем при загрузке питомцев из очереди."
	L["Double Click To Send To Top"] = "Двойной щелчок, чтобы отправить в начало."
	L["When a pet in the queue panel is double clicked, send it to the top of the queue instead of summoning it."] = "При двойном клике на питомца в очереди прокачивания, отправить его в верхнюю часть очереди, а не вызвать его."
	L["Hide Leveling Pet Toast"] = "Скрыть прокачивание Pet Toast"
	L["Don't display the popup 'toast' when a new pet is automatically loaded from the leveling queue."] = "Не отображать всплывающее «Pet Toast», когда новый питомец  автоматически загружается из очереди прокачивания."
	L["Automatically Level New Pets"] = "Автоматическое прокачивание нового питомца"
	L["When you capture or learn a pet, automatically add it to the leveling queue."] = "Когда вы ловите или изучаете нового питомца, автоматически добавлять его в очередь прокачивания."
	L["Only Pets Without A 25"] = "Только для питомце до 25 уровня"
	L["Only automatically level pets which don't have a version already at 25 or in the queue."] = "Автодобавление в очередь для прокачивание питомца который не имеет версии 25 уровня и отсутсвует в очереди."
	L["Only Rare Pets"] = "Только питомцы редкого качества"
	L["Only automatically level rare quality pets."] = "Автоматически добавлять только питомцев редкого качества."
	L["Pet Filter Options"] = "Параметры фильтра для питомцев"
	L["Reset Filters On Login"] = "Сброс фильтров при входе в систему"
	L["When logging in, start with all pets listed and no filters active."] = "При входе в систему начинать со всех перечисленных питомцев и активных фильтров."
	L["Reset Sort With Filters"] = "Сбросить сортировку с фильтрами"
	L["When clearing filters, also reset the sort back to the default: Sort by Name, Favorites First."] = "При очистке фильтров также сбросить сортировку до значения по умолчанию: Сортировка по имени, Избранные сначала."
	L["Don't Reset Search With Filters"] = "Не сбрасывать поиск с помощью фильтров"
	L["When manually clearing filters, don't clear the search box too.\n\nSome actions, such as logging in or Find Similar, will always clear search regardless of this setting."] = "При ручной очистке фильтров также не очищать окно поиска. \n\nНекоторые действия, такие как вход в систему или поиск похожих, всегда будут очищать поиск независимо от этого параметра."
	L["Sort By Chosen Name"] = "Сортировать по изменённому имени"
	L["When pets are sorted by name, sort them by the name given with the Rename option instead of their original name."] = "Когда питомцы сортируются по имени, сортировать их по имени, указанному в опции «Переименовать», вместо оригинального имени."
	L["Don't Sort By Relevance"] = "Не сортировать по актуальности" 
	L["When searching for something by name in the search box, do not sort the results by relevance.\n\nWhen sorted by relevance, pets with the search term in their name are listed first, followed by terms in notes, then abilities and then source text last."] = "Когда вы вводите имя в строке поиска, не сортировать результатыты по акктуальности.\n\nКогда сортируется по актуальности,сначало идут питомцы с критериеем на поиск их имени , заметка для команды, потом способности и в конце исходный текст."
	L["Confirmation Options"] = "Параметры подтверждения"
	L["Don't display a popup when a team loads and a pet within the team can't be found."] = "Не показывать всплывающее окно, когда команда загружается, а питомец внутри команды не может быть найден."
	L["Don't ask for confirmation when hiding a pet.\n\nYou can view hidden pets in the 'Other' pet filter."] = "Не спрашивать подтверждения при скрытии питомца. \n\n Вы можете просматривать скрытых питомцев в фильтре «Другой»."
	L["Don't Remind About Backups"] = "Не напоминать о резервном копировании"
	L["Don't show a popup offering to backup teams every once in a while. Generally, the popup appears sometime after the number of teams increases by 50."] = "Не показывать всплывающее предложение для групп резервного копирования. Как правило, всплывающее окно появляется через некоторое время после того, как количество команд увеличивается на 50."
	L["Miscellaneous Options"] = "Разное"
	L["Show After Pet Battle"] = "Показать после битвы питомцев"
	L["Show the Rematch window after leaving a pet battle."] = "Показать окно Rematch после выхода из боя с амирсцами."
	L["Disable Sharing"] = "Отключить обмен"
	L["Disable the Send button and also block any incoming pets sent by others. Import and Export still work."] = "Отключить кнопку отправки, а также заблокировать всех входящих команд питомцев, отправленных другими пользователями. Импорт и экспорт по-прежнему работают."
	L["Use Minimap Button"] = "Использование кнопки Мини-карты"
	L["Place a button on the minimap to toggle Rematch and load favorite teams."] = "Поместить кнопку на мини-карту для переключения Rematch и загрузки избранных команд."
	L["Keep Companion"] = "Оставлять спутника"
	L["After a team is loaded, summon back the companion that was at your side before the load; or dismiss the pet if you had none summoned."] = "После того, как команда загружена, вызвать обратно спутника, который был призван перед загрузкой или убрать питомца, если он не был вызван."
	L["No Summon On Double Click"] = "Не призывать питомца при двойном клике"
	L["Do nothing when pets within Rematch are double-clicked. The normal behavior of double click throughout Rematch is to summon or dismiss the pet."] = "Не делать ничего, когда вы в Rematch дважды щелкаете по питомцу. Обычное поведение двойного клика в Rematch - вызов или отпускание питомца."
	L["Hide Tooltips"] = "Скрыть подсказки"
	L["Hide the more common tooltips in Rematch."] = "Скрыть более распространенные всплывающие подсказки в Rematch."
	L["Hide Extra Help"] = "Скрыть дополнительную помощь"
	L["Hide the informational \"Help\" items found in many menus and on the pet card."] = "Скрыть информационные элементы \"Помощь\", находящиеся во многих меню и на карточке питомца."
	L["Use Default Pet Journal"] = "Использовать стандартный Атлас питомцев"
	L["Turn off Rematch integration with the default pet journal.\n\nYou can still use Rematch in its standalone window, accessed via key binding, /rematch command or from the Minimap button if enabled in options."] = "Отключить интеграцию Rematch со стандартным Атласом питомцев. \n\nВы можете использовать Rematch в Автономном окне, доступ к которому можно выполнить с помощью команды /rematch  или с помощью кнопки Мини-карты, если она включена в параметрах."
	L["Rematch version %s"] = "Rematch версия %s"
	L["The%s icon indicates new options."] = "Значок %s показывает новые параметры."
	L["Anchor"] = "Привязка"
	L["%s\n\n%sWARNING!\124r There may be an issue with pet toasts in ElvUI not positioning properly. While using ElvUI it's recommended pet toasts remain hidden unless you've moved alerts in ElvUI."] = "%s\n\n%sWARNING!\124r В ElvUI может возникнуть проблема с неправильным позиционированием питомцев. При использовании ElvUI рекомендуется, чтобы Pet Toast оставались скрытыми, если вы переместили оповещения в ElvUI."
	L["Bottom Right"] = "Внизу справа"
	L["Top Right"] = "В правом верхнем углу"
	L["Bottom Left"] = "Нижняя левая"
	L["Top Left"] = "Верхний левый"
	L["Anchor: %s"] = "Привязка: %s"
	L["When the standlone window is minimized, send it to the %s corner."] = "Когда отдельное окно сведено к минимуму, отправьте его в %s угол."
	L["Current Scale: %d%%"] = "Текущий масштаб: %d%%"
	L["Click here to choose a different scale for the standalone window."] = "Нажмите здесь, чтобы выбрать другой масштаб для Автономного окна."
	L["\n\n%sThis will close the journal and open the standalone window."] = "\n\n%sЭто закроет Атлас питомцев и откроет Автономное окно."
	L["Reload the UI now?"] = "Перезагрузить пользовательский интерфейс?"
	L["You've chosen to change the setting for Compact List Format.\n\nThis change doesn't take effect until a reload or logout."] = "Вы решили изменить настройку формата Компактного списка. \n\nЭто изменение не вступает в силу до перезагрузки или выхода из системы."
	L["Custom Scale"] = "Пользователький масштаб"
	L["Keep this scale?"] = "Сохранить этот масштаб?"
	L["This scale determines the relative size of the standalone window, where 100% is the standard size."] = "Эта шкала определяет относительный размер отдельного окна, где 100% является стандартным размером."
	L["Randomize Abilities Too"] = "Случайные способности так же"
	L["For random pets, randomize the pets' abilities also."] = "Для случайных питомцев, распределить способности случайным образом, а не так как они у Вас выбраны в атласе питомцев."
	L["In addition to the flyouts, show the numbers 1 and 2 on loaded abilities."] = "В дополнение к всплывающим подсказкам, показать номера 1 и 2 на загруженных способностях."
	L["When a team auto loads, show the Rematch window if any pets in the team are injured."] = "При автоматической загрузке команды показать окно Rematch, если какой-либо из загруженных питомцев в команде ранен."
	L["Hide Non-Battle Pets"] = "Скрыть питомцев не для битв"
	L["Only list pets that can battle. Do not list pets like balloons, squires and other companion pets that cannot battle."] = "Показать только тех питомцев которые могу участвовать в битвах. Не показывать питомцев таких как воздушные шары, сквайры и другие питомцы, которые не могут участвовать в битвах питомцев."

-- Widgets\BottomPanel.lua
	L["You can also double-click a pet to summon or dismiss it."] = "Вы также можете дважды щелкнуть на питомца, чтобы вызвать или отпустить его."
	L["Disable Rematch"] = "Отключить Rematch"
	L["Uncheck this to restore the default pet journal.\n\nYou can still use Rematch in its standlone window, accessed via key binding, /rematch command or from the Minimap button if enabled in options."] = "Снимите этот флажок, чтобы восстановить Атлас боевых питомцев по умолчанию. \n\nВы можете использовать Rematch в своем отдельном окне, доступ к которому осуществляется с помощью команды /rematch или с помощью кнопки Мини-карты, если она включена в параметрах."

-- Widgets\TeamTabs.lua
	L["Edit Tab"] = "Редактировать вкладку"
	L["Change the name or icon of this tab."] = "Изменить имя или значок этой вкладки."
	L["Custom Sort"] = "Пользовательская сортировка"
	L["Remove Custom Sort"] = "Удалить пользовательскую сортировку"
	L["Are you sure you want to remove the custom sort order?\n\nThe saved order of teams will be lost and turning this option back on will not restore the old order."] = "Вы уверены, что хотите удалить заказ пользовательского порядка? \n\nСохраненный порядок команд будет потерян, и включение этой опции не приведет к восстановлению старого порядка."
	L["While checked, you can rearrange the order of teams within this tab from the teams' right-click menu."] = "При проверке вы можете изменить порядок команд на этой вкладке в меню правой кнопкой мыши."
	L["Sort By Wins"] = "Сортировать по победам"
	L["This option is disabled while Custom Sort is active."] = "Этот параметр отключен, пока Пользовательская сортировка активна."
	L["Sort teams in this tab by their wins.\n\nFavorited teams will still list at the top."] = "Сортировать команды на этой вкладке по своим победам. \n\nИзбранные команды по-прежнему будут отображаться наверху."
	L["Set leveling preferences for all teams within this tab.\n\nIf a team within this tab also has preferences, the tab's preferences will take priority over the team's preferences."] = "Установить предпочтения прокачивания для всех команд на этой вкладке. \n\nЕсли команда на этой вкладке также имеет предпочтения, предпочтения вкладки будут иметь приоритет над предпочтениями команды."
	L["Export Tab"] = "Экспортировать вкладку"
	L["Export all teams in this tab to a string you can copy elsewhere, such as forums or emails.\n\nOther Rematch users can then paste these teams into their Rematch via Import Teams.\n\nYou can export a single team by right-clicking one and choosing its Share menu."] = "Экспортировать все команды на этой вкладке в строку, которую вы можете скопировать в другое место, например, форумы или электронные письма. \n\nДругие пользователи Rematch могут затем вставить эти команды в свой Rematch через команды импорта. \n\nВы можете экспортировать одну команду по правому клику мышкой выбрав в меню «Поделиться»."
	L["Delete Tab"] = "Удалить вкладку"
	L["Delete this tab and move all of its teams to the default tab."] = "Удалить эту вкладку и переместить все ее команды на вкладку по умолчанию."
	L["Create New Tab"] = "Создать новую вкладку"
	L["Teams: %d"] = "Команды: %d"
	L["New Tab"] = "Новая вкладка"
	L["Choose a name and icon"] = "Выбрать имя и значок"
	L["Delete this tab?"] = "Удалить эту вкладку?"
	L["Deleting this tab will move its teams to the %s tab."] = "Удаление этой вкладки приведет к перемещению ее команд на вкладку %s."
	L["Delete teams within the tab too"] = "Также удалить команды на вкладке"
	L["%sWARNING!\124r This will %sPERMANENTLY DELETE\124r all teams in this tab!"] = "%ПРЕДУПРЕЖДЕНИЕ!\124r Это приведёт к % БЕЗВОЗВРАТНОМУ УДАЛЕНИЮ \124r всех команд на этой вкладке!"

-- Widgets\LoadedTeamPanel.lua
	L["Reload Team"] = "Обновить команду"
	L["When a team is loaded its name goes here. You can reload the team by clicking here or right-click for team options such as setting notes."] = "Когда команда загружается, ее имя здесь. Вы можете перезагрузить команду, нажав здесь или нажать правой кнопкой мыши параметры команды, такие как установочные примечания."
	L["Last Loaded Team"] = "Последняя загруженная команда"

-- Dialogs\Save.lua
	L["Target For This Team"] = "Цель этой команды"
	L["A target stored in a team is used to decide which team to load when you return to that target.\n\nYou can save an unlimited number of teams to fight a target, but a target can only be saved in one team."] = "Цель, хранящаяся в команде, используется для определения того, какая команда загружается, когда вы возвращаетесь к этой цели. \n\nВы можете сохранить неограниченное количество команд для борьбы с целью, но цель может быть сохранена только в одной команде."
	L["Name:"] = "Имя:"
	L["Target:"] = "Цель:"
	L["Save As.."] = "Сохранить как.."
	L["Save this team?"] = "Сохранить эту группу?"
	L["Save Notes & Preferences Too"] = "Сохранить примечания и предпочтения тоже"
	L["All teams must have a name."] = "Все команды должны иметь имя."
	L["This target already has a team."] = "У этой цели уже есть команда."
	L["A team already has this name."] = "У команды уже есть это имя."
	L["Overwrite Team"] = "Перезаписать команду"
	L["Overwrite this team?"] = "Перезаписать эту команду?"
	L["The target %s%s\124r already has a team.\n\nA target can only have one team."] = "У цели% %s%s\124r уже есть команда. \n\nУ каждой цели может быть только одна команда."
	L["A team named %s%s\124r already exists.\n\nTeams without a target must have a unique name."] = "Команда с именем %s%s\124r уже существует. \n\nКоманды без цели должны иметь уникальное имя."

-- Dialogs\Preferences.lua
	L["Minimum Health"] = "Минимальное здоровье"
	L["This is the minimum health preferred for a leveling pet.\n\nThe queue will prefer leveling pets with at least this much health (adjusted by expected damage taken if any chosen)."] = "Это минимальное здоровье, предпочтительное для прокачиваемого питомца. \n\nОчередь будет предпочитать прокачивание питомцев, по крайней мере, с таким или большим здоровьем."
	L["Minimum Level"] = "Минимальный уровень"
	L["This is the minimum level preferred for a leveling pet.\n\nLevels can be partial amounts. Level 4.33 is level 4 with 33% xp towards level 5."] = "Это минимальный уровень, предпочтительный для прокачивания питомца. \n\nУровень может быть частичным. Уровень 4.33 - уровень 4 с 33% опыта от уровня 5."
	L["Maximum Health"] = "Максимальное здоровье"
	L["This is the maximum health preferred for a leveling pet."] = "Это максимальное здоровье для прокачиваемого питомца."
	L["Maximum Level"] = "Максимальный уровень"
	L["This is the maximum level preferred for a leveling pet.\n\nLevels can be partial amounts. Level 23.45 is level 23 with 45% xp towards level 24."] = "Это максимальный уровень, предпочтительный для прокачивания питомца. \n\nУровень может быть частичным. Уровень 23.45 - уровень 23 с 45% опыта от уровня 24."
	L["Or any"] = "Или любой"
	L["Allow low-health Magic and Mechanical pets to ignore the Minimum Health, since their racials allow them to often survive a hit that would ordinarily kill them."] = "Позволяет магическим и механическим питомцам с низким уровнем здоровья игнорировать минимальное здоровье, поскольку их расы позволяют им часто выживать в результате удара, который обычно убивал бы их."
	L["Expected damage taken"] = "Ожидаемый урон"
	L["Tab"] = "Вкладка"
	L["Team Preferences"] = "Предпочтения команды"
	L["Tab Preferences"] = "Предпочтения вкладки"
	L["  For %s pets: %s%d%s"] = "  Для %s питомцев: %s%d%s"
	L["%s %sTab Preferences"] = "%s %sПредпочтения вкладки"
	L["%s%s Preferences Paused"] = "%s%s Предпочтения приостановлены"
	L["%s Resume Preferences"] = "%s Возобновить предпочтение"
	L["%s Pause Preferences"] = "%s Приостановить предпочтение"
	L["Leveling Preferences For %s:"] = "Предпочтения прокачивания для %s:"
	L["Expected Damage Taken"] = "Ожидается тип урона от"
	L["The minimum health of pets can be adjusted by the type of damage they are expected to receive."] = "Минимальное здоровье питомцев может быть скорректировано по типу урона, который они должны получить."
	L["Damage expected"] = "Ожидаемый урон"
	L["  For %s pets: \124cffffd200%d"] = "  Для %s питомцев: \124cffffd200%d"

-- Dialogs\Sideline.lua
	L["New Team"] = "Новая команда"

-- Dialogs\Share.lua
	L["Press Ctrl+C to copy these teams to the clipboard."] = "Нажмите Ctrl + C, чтобы скопировать эти команды в буфер обмена."
	L["Press Ctrl+C to copy this team to the clipboard."] = "Нажмите Ctrl + C, чтобы скопировать эту команду в буфер обмена."
	L["Include Preferences"] = "Включить предпочтения"
	L["Include Notes"] = "Включить заметки"
	L["Press Ctrl+V to paste a team from the clipboard."] = "Нажмите Ctrl + V, чтобы вставить команду из буфера обмена."
	L["Only Load This Team"] = "Только загрузить команду"
	L["This will only load the team and not save it.\n\nThis is for loading teams you do not intend to use more than once, like Family Familiar teams."] = "Это только загрузит команду но не сохранит её. \n\nДля загрузки команд, которые вы не собираетесь использовать более одного раза, например для достижений Знакомые все лица, Ужасно большое приключение."
	L["This is not a recognizable team."] = "Это не узнаваемая команда."
	L["An existing team already has this %s."] = "У уже существующей команды еть эта %s."
	L["target"] = "цель"
	L["name"] = "имя"
	L["Create a new copy"] = "Создать новую копию"
	L["Overwrite existing team"] = "Перезаписать существующую команду"
	L["%s%d\124r teams are in this import."] = "%s%d\124r Команды в этом импорте."
	L["%s%d\124r have a name or target already used."] = "%s%d\124r уже имеет используемое имя или цель."
	L["Create new copies"] = "Создать новую копию"
	L["Overwrite existing teams"] = "Перезаписать существующие команды"
	L["Send"] = "Отправить"
	L["Who do you want to send this team to?"] = "Кому вы хотите отправить эту команду?"
	L["Sending..."] = "Отправка..."
	L["No response. Lag or they don't have Rematch?"] = "Нет ответа. Лаг или у них нет Rematch."
	L["Team successfully received!"] = "Команда успешно получена!"
	L["Sending...%d%%"] = "Отправка...%d%%"
	L["They're busy. Try again later."] = "Они заняты. Попробуйте позже."
	L["They're in combat. Try again later."] = "Они в бою. Попробуйте позже."
	L["They have team sharing disabled."] = "У них отключен обмен командой."
	L["Incoming Rematch Team!"] = "Входящая команда Rematch!"
	L["%s%s\124r has sent you a team named \"%s\" (for %s)."] = "%s%s\124r Отправил вам команду под названием \"%s\" (für %s) geschickt."
	L["%s%s\124r has sent you a team for %s."] = "%s%s\124r Отправил вам команду для %s."
	L["%s%s\124r has sent you a team named \"%s\"."] = "%s%s\124r Отправил вам команду под названием \"%s\"."
	L["Import these teams?"] = "Импортировать эти команды?"
	L["Import"] = "Импортировать"
	L["%s%d\124r Rematch teams have the same name."] = "%s%d\124r Rematch Команды имеют одно и то же имя."
	L["Please Wait..."] = "Пожалуйста подождите..."
	L["Note: These are just your teams and their notes and preferences. Tab information, sort orders, win records and other settings are not included.\n\nFor the most complete backup of all your addon data, please backup your Word of Warcraft\\WTF folder."] = "Примечание. Это только ваши команды, их заметки и предпочтения. Информация о вкладе, порядок сортировки, записи побед и другие параметры не включены. \n\nДля самой полной резервной копии всех ваших данных аддона сделайте резервнау копию вашей папки Word of Warcraft \\ WTF."
	L["Press Ctrl+C to copy these teams to the clipboard. Then paste them into an email to yourself or a text file someplace safe.\n\nIf you ever need to restore your teams, paste them back in with Import Teams."] = "Нажмите Ctrl + C, чтобы скопировать эти команды в буфер обмена, а затем вставьте их в электронную почту для себя или текстового файла. \n\nЕсли вам когда-либо понадобится восстановить свои команды, вставьте их обратно с помощью Импорт команд."
	L["Backup All Rematch Teams?"] = "Сделать резервное копирование всех команд Rematch?"
	L["You have %s%d\124r Rematch teams.\n\nWould you like to back them up?"] = "У вас есть  %s%d\124r команда Rematch. \n\nВы хотите создать резервную копию?"
	L["Choosing Yes will export all teams to copy and paste in an email to yourself or someplace safe.\n\nYou can also do this at any time from the Teams button at the top of the Teams panel of Rematch."] = "Выбор «Да» будет экспортировать все команды, чтобы скопировать и вставить электронное письмо в себя или в безопасное место. \n\Вы также можете сделать это в любое время с помощью кнопки «Команды» в верхней части панели «Команды» Rematch."

-- Dialogs\Tooltip.lua

-- Dialogs\ScriptFilter.lua
	L["Pet Variables"] = "Примеры фильтров"
	L["Exposed API"] = "Открыть API"
	L["Test"] = "Тестирование"
	L["line "] = "Строка"
	L["Pet Filter Script Error"] = "Ошибка скрипта фильтра питомцев"
	L["Error in %s"] = "Ошибка в %s"
	L["\124TInterface\\RaidFrame\\ReadyCheck-NotReady:16\124t Error %s"] = nil
	L["\124TInterface\\RaidFrame\\ReadyCheck-Ready:16\124t Script ran without errors!"] = nil
	L["\124cffffd200-\124r Scripts are a way to create custom pet filters.\n\n\124cffffd200-\124r Scripts are Lua code and require some knowledge of the language and API to create your own filters.\n\n\124cffffd200-\124r Scripts run for each pet and should return true if the pet is to be listed.\n\n\124cffffd200-\124r Some variables are filled in as the script runs for each pet. See Pet Variables.\n\n\124cffffd200-\124r Scripts run in a restricted environment with no access outside its environment. See Exposed API.\n\n\124cffffd200-\124r All variables/tables created exist only in this environment and disappear when the filter finishes.\n\n\124cffffd200-\124r If the first line of the script is a --comment, it will be used as a tooltip in the Script menu."] = nil
	L["These variables are defined as the script runs for each pet:\n\n\124cffffd200owned\124r \124cffaaaaaa(boolean)\124r\nWhether the pet is owned by the player.\n\n\124cffffd200petID\124r \124cffaaaaaa(string)\124r\nUnique ID of the owned pet, such as \"BattlePet-0-000004A98F18\".\n\n\124cffffd200speciesID\124r \124cffaaaaaa(number)\124r\nShared ID of the pet's family. Black Tabby Cats are species 42.\n\n\124cffffd200customName\124r \124cffaaaaaa(string)\124r\nName given to the pet by the player.\n\n\124cffffd200level\124r \124cffaaaaaa(number)\124r\nLevel of the pet, or nil for uncollected pets.\n\n\124cffffd200xp\124r \124cffaaaaaa(number)\124r\nAmount of xp the pet has in its current level.\n\n\124cffffd200maxXp\124r \124cffaaaaaa(number)\124r\nTotal amount of xp required to reach the pet's next level.\n\n\124cffffd200displayID\124r \124cffaaaaaa(number)\124r\nA numeric representation of a pet's model skin.\n\n\124cffffd200isFavorite\124r \124cffaaaaaa(boolean)\124r\nWhether the pet is favorited by the player.\n\n\124cffffd200name\124r \124cffaaaaaa(string)\124r\nTrue name of the pet species.\n\n\124cffffd200icon\124r \124cffaaaaaa(string)\124r\nTexture path of the pet's icon.\n\n\124cffffd200petType\124r \124cffaaaaaa(number)\124r\nValue between 1 and 10 for its type. 1=Humanoid, 2=Dragonkin, etc.\n\n\124cffffd200creatureID\124r \124cffaaaaaa(number)\124r\nThe npcID of the pet when it's summoned.\n\n\124cffffd200sourceText\124r \124cffaaaaaa(string)\124r\nFormatted text describing where the pet is from.\n\n\124cffffd200description\124r \124cffaaaaaa(string)\124r\nLore text of the species.\n\n\124cffffd200isWild\124r \124cffaaaaaa(boolean)\124r\nWhether the pet was a captured wild pet.\n\n\124cffffd200canBattle\124r \124cffaaaaaa(boolean)\124r\nWhether the pet can battle.\n\n\124cffffd200tradable\124r \124cffaaaaaa(boolean)\124r\nWhether the pet can be caged.\n\n\124cffffd200unique\124r \124cffaaaaaa(boolean)\124r\nWhether no more than one of the pet can be known at a time.\n\n\124cffffd200abilityList\124r \124cffaaaaaa(table)\124r\nArray of abilityIDs used by the species.\n\n\124cffffd200levelList\124r \124cffaaaaaa(table)\124r\nArray of levels the abilityIDs are learned.\n\nFurther information about pets can be retrieved with the \124cffffd200petInfo\124r system. See Process\\PetInfo.lua for more information."] = nil
	L["The script environment is restricted with access to only common Lua and the following:\n\n\124cffffd200C_PetJournal \124cffaaaaaa(table)\124r\nThe default API for journal functions.\n\n\124cffffd200C_PetBattles \124cffaaaaaa(table)\124r\nThe default API for the battle UI.\n\n\124cffffd200GetBreed \124cffaaaaaa(function)\nArgument:\124r petID\n\124cffaaaaaaReturns:\124r The numeric breed (3-12) of a petID if one of the supported breed addons is enabled.\n\n\124cffffd200GetSource \124cffaaaaaa(function)\nArgument:\124r speciesID\n\124cffaaaaaaReturns:\124r The numeric source (1-10) of a speciesID. 1=Drop, 2=Quest, etc.\n\n\124cffffd200IsPetLeveling \124cffaaaaaa(function)\nArgument:\124r petID\n\124cffaaaaaaReturns:\124r Whether the given petID is in the leveling queue.\n\nA few iterator functions are also provided if you need to compare a pet against others. These are used in a for loop such as:\n\n\124cffcccccc    for speciesID in \124cffffd200AllSpeciesIDs()\124cffcccccc do\n      -- do something with speciesID\n    end\124r\n\n\124cffffd200AllSpeciesIDs \124cffaaaaaa(iterator function)\nReturns:\124r The next speciesID of all existing unique pets.\n\n\124cffffd200AllPetIDs \124cffaaaaaa(iterator function)\nReturns:\124r The next petID of all owned pets.\n\n\124cffffd200AllPets \124cffaaaaaa(iterator function)\nReturns:\124r The next petID or speciesID of all pets in the master list. Owned pets return a petID string, uncollected pets return a speciesID number.\n\n\124cffffd200AllAbilities \124cffaaaaaa(iterator function)\nArgument:\124r speciesID\n\124cffaaaaaaReturns:\124r The next abilityID and level of the ability for a speciesID.\n\124cffffd200Note:\124r abilityList and levelList are already defined for each pet as your script runs. Use this iterator if you need to gather abilities of other pets for comparison. See the Unique Abilities script for an example.\n\n\124cffffd200If you would like anything else exposed please post a comment on wowinterface, curse or warcraftpet's Rematch 4.0 thread."] = nil

-- Dialogs\Collection.lua
	L["Total Collected Pets"] = "Всего собрано питомцев"
	L["Unique Collected Pets"] = "Собрано уникальных питомцев"
	L["Pets Not Collected"] = "Не полученные питомцы"
	L["Percent Collected"] = "Процент собран"
	L["Max Level Pets"] = "Питомцев максимального уровня"
	L["Rare Quality Pets"] = "Питомцев редкого качества"
	L["Unique Pets In The Game"] = "Уникальных питомцев в игре"
	L["Collection Statistics"] = "Статистика коллекции"
	L["There are %s%d\124r unique pets in the game."] = "В игре есть всего %s%d\124r уникальных питомцев."
	L["Pets Collected"] = "Питомцев собрано"
	L["Pets At Max Level"] = "Максимального уровня"
	L["Total"] = "Всего"
	L["Unique"] = "уникальных"
	L["Duplicate Collected Pets"] = "Собрано одинаковых питомцев"
	L["Average Battle Pet Level"] = "Средний уровень боевого питомца"
	L["You have %s%.1f%%\124r of all unique pets."] = "Собрано %s%.1f%%\124r всего уникальных питомцев."
	L["All unique pets in the game."] = "Всего уникальных питомцев в игре."
	L["All pets you've collected, including duplicates."] = "Все питомцы, которые вы собрали, включая дубликаты."
	L["The unique pets you've collected, not including duplicates."] = "Уникальных питомцев, которые вы собрали, не включая дубликаты."
	L["The unique pets you're missing."] = "Уникальных питомцев, которых вам не хватает."
	L["How much of each category's unique pets you've collected as a percent."] = "Сколько уникальных питомцев каждой категории вы собрали в процентах."
	L["All of your level 25 pets, including duplicates."] = "Все ваши питомцы уровня 25, включая дубликаты."
	L["All of your rare quality pets, including duplicates."] = "Все ваши редкие питомцы, включая дубликаты."
	L["Pet Types"] = "Типы питомцев"
	L["Sources"] = "Источники"

-- Frames\Frame.lua
	L["Pets"] = "Питомцы"
	L["Options"] = "Настройки"
	L["Toggle Single Panel Mode"] = "Переключение режима одиночной панели."
	L["Toggle between one panel or two panels side by side."] = "Переключение между одной панелью или двумя панелями бок о бок."
	L["You are in combat. Try again when out of combat."] = "Вы в бою. Повторите попытку, когда выйдите из боя."

-- Frames\Configure.lua

-- Frames\Journal.lua
	L["Enable Rematch"] = "Включить Rematch"
	L["Check this to use Rematch in the pet journal."] = "Нажмите здесь чтобы использовать Rematch в Атласе питомцев."

-- Process\Battle.lua
	L["Show Pet Card"] = "Показать карточку питомца"

-- Process\Breeds.lua
    L["This slot is controlled by the leveling queue.\n\nTeams saved with leveling slots will load leveling pets from the queue into these slots."] = "Этот слот предназначен для очереди прокачивания.\n\nКогда загружается команда с сохранённым слотом для прокачивания, питомец из очереди прокачивания занимает этот слот."
	L["Leveling Slot"] = "Слот для прокачивания"

end